#ifndef ocs_H
#define ocs_H

#include <QUrl>
#include <QFile>
#include <QString>
#include <QDebug>
#include <QNetworkRequestFactory>
#include <QRestReply>
#include <QRestAccessManager>
#include <QOAuth2AuthorizationCodeFlow>
#include <QOAuthHttpServerReplyHandler>
#include <QOAuthUriSchemeReplyHandler>
#include <QNetworkReply>
#include <QJsonDocument>
#include <QJsonObject>
#include <QJsonArray>
#include <QUrlQuery>
#include <QMessageBox>
#include <QSettings>
#include <QEventLoop>
#include <QStandardItemModel>
#include <QCryptographicHash>
#include <QDomDocument>
#include <QtQml/qqml.h>
#include "storageservice.h"

QT_FORWARD_DECLARE_CLASS(QRestAccessManager)

class Nextcloud : public StorageService
{
    Q_OBJECT
    QML_ELEMENT

public:
    Nextcloud(QString baseUrl, QObject *parent = nullptr);

    void authenticate() override;
    void revoke() override;
    Q_INVOKABLE void setToken(const QString token);
    QString errorString();

    QDateTime upload(QString localFileName, QString relativeCloudFileName) override;
    QDateTime upload(QByteArray data, QString relativeCloudFileName) override;

    void download(QString relativeCloudFileName, QString localFileName, QDateTime &modifiedDate) override;
    void download(QString relativeCloudFileName, QByteArray &content, QDateTime &modifiedDate) override;

    QDateTime getModifiedDate(QString cloudFileName) override;
    bool deleteFile(QString cloudFileName) override;

    bool createFolder(QString path) override;
    QString getSharedLink(QString path) override;

    bool fileExists(QString path) override;

    void loadAccount() override;

    Q_INVOKABLE QAbstractItemModel *searchFile(QString query) override;
    QList<StorageUser> listFolderMembers(QString path) override;

    Q_INVOKABLE bool getAccessToken(QString code) override;

private:
    QString getFileOwner(QString path);

    QString m_error = "";
    QNetworkRequestFactory ncApi;
    QRestAccessManager *network = nullptr;
    QOAuth2AuthorizationCodeFlow *ncAuth;
    QOAuthUriSchemeReplyHandler *uriSchemeReplyHandler;
    QString apiBaseUrl;
    QString accessTokenUrl;
    QString authorizationUrl;
    QSettings settings;

    QDateTime tokenExpiration;

    bool initLoginFlow();
    void initCall();
    bool refreshAccessToken();
    void saveSettings(const QJsonDocument doc);

    QString readReply(QRestReply &reply, QString messageTemplate);
};

#endif // ocs_H
